﻿<?php
return [
    'SITE_NAME' => getenv('SITE_NAME') ?: 'NebulaCanvas',
    'SITE_URL' => getenv('SITE_URL') ?: 'https://example.com',
    'ENV' => getenv('APP_ENV') ?: 'production',
    'CRON_TOKEN' => getenv('CRON_TOKEN') ?: 'set-a-secure-token',
    'RATE_LIMIT_MAX' => (int)(getenv('RATE_LIMIT_MAX') ?: 10),
    'RATE_LIMIT_WINDOW_SEC' => (int)(getenv('RATE_LIMIT_WINDOW_SEC') ?: 60),
    'DB_PATH' => getenv('DB_PATH') ?: __DIR__ . '/public_html/storage/meta/app.sqlite',
    'STORAGE_DIR' => getenv('STORAGE_DIR') ?: __DIR__ . '/public_html/storage/images',
    'LOG_PATH' => getenv('LOG_PATH') ?: __DIR__ . '/public_html/storage/meta/app.log',
    'WATERMARK_ENABLED' => (bool)(getenv('WATERMARK_ENABLED') !== false ? filter_var(getenv('WATERMARK_ENABLED'), FILTER_VALIDATE_BOOLEAN, FILTER_NULL_ON_FAILURE) ?? true : true),
    'WATERMARK_TEXT' => getenv('WATERMARK_TEXT') ?: 'Generated @ NebulaCanvas',
    'PROVIDER' => getenv('PROVIDER') ?: 'mock',
    'REMOTE_HTTP_ENDPOINT' => getenv('REMOTE_HTTP_ENDPOINT') ?: 'https://api.example.com/generate',
    'REMOTE_HTTP_API_KEY' => getenv('REMOTE_HTTP_API_KEY') ?: '',
    'REMOTE_HTTP_TIMEOUT' => (int)(getenv('REMOTE_HTTP_TIMEOUT') ?: 60),
    'MOCK_PLACEHOLDER_PATH' => getenv('MOCK_PLACEHOLDER_PATH') ?: '',
    'ALLOW_GALLERY' => (bool)filter_var(getenv('ALLOW_GALLERY') ?: 'true', FILTER_VALIDATE_BOOLEAN),
];