﻿<?php

namespace App\Lib;

class Id
{
    private const ENCODING = '0123456789ABCDEFGHJKMNPQRSTVWXYZ';

    public static function ulid(): string
    {
        $time = (int) floor(microtime(true) * 1000);
        $timeChars = '';
        for ($i = 0; $i < 10; $i++) {
            $mod = $time % 32;
            $timeChars = self::ENCODING[$mod] . $timeChars;
            $time = intdiv($time, 32);
        }
        $random = random_bytes(10);
        $randChars = '';
        foreach (str_split(bin2hex($random), 2) as $pair) {
            $randChars .= self::ENCODING[hexdec($pair) % 32];
        }
        return $timeChars . substr($randChars, 0, 16);
    }

    public static function short(): string
    {
        return substr(self::ulid(), -8);
    }
}