﻿<?php

namespace App\Lib;

use App\Lib\Providers\MockProvider;
use App\Lib\Providers\RemoteHTTPProvider;
use RuntimeException;

interface ImageProvider
{
    public function generate(array $payload): ImageProviderResult;
}

class ImageProviderResult
{
    public string $mime;
    public string $binary;
    public array $metadata;

    public function __construct(string $mime, string $binary, array $metadata = [])
    {
        $this->mime = $mime;
        $this->binary = $binary;
        $this->metadata = $metadata;
    }
}

class ImageProviderFactory
{
    public static function make(): ImageProvider
    {
        $config = Env::all();
        $provider = strtolower((string)($config['PROVIDER'] ?? 'mock'));
        return match ($provider) {
            'remote_http' => new RemoteHTTPProvider(),
            'mock' => new MockProvider(),
            default => throw new RuntimeException('Unknown provider: ' . $provider),
        };
    }
}