﻿<?php

namespace App\Lib;

use Throwable;

class Logger
{
    public static function info(string $message, array $context = []): void
    {
        self::write('INFO', $message, $context);
    }

    public static function error(string $message, array $context = []): void
    {
        self::write('ERROR', $message, $context);
    }

    public static function exception(Throwable $throwable): void
    {
        self::write('EXCEPTION', $throwable->getMessage(), [
            'trace' => $throwable->getTraceAsString(),
        ]);
    }

    private static function write(string $level, string $message, array $context): void
    {
        $config = Env::all();
        $path = $config['LOG_PATH'] ?? __DIR__ . '/../public_html/storage/meta/app.log';
        $dir = dirname($path);
        if (!is_dir($dir)) {
            mkdir($dir, 0775, true);
        }
        $line = sprintf(
            "[%s] %s %s %s\n",
            gmdate('c'),
            $level,
            $message,
            $context ? json_encode($context, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) : ''
        );
        file_put_contents($path, $line, FILE_APPEND);
    }
}