﻿<?php

require_once __DIR__ . '/helpers.php';

function render_header(string $active = ''): void
{
    $siteName = site_config('SITE_NAME', 'NebulaCanvas');
    $nav = [
        ['href' => site_url('index.php'), 'label' => 'Home', 'id' => 'home'],
        ['href' => site_url('features.php'), 'label' => 'Features', 'id' => 'features'],
        ['href' => site_url('generate.php'), 'label' => 'Generate', 'id' => 'generate'],
        ['href' => site_url('faq.php'), 'label' => 'FAQ', 'id' => 'faq'],
        ['href' => site_url('blog.php'), 'label' => 'Blog', 'id' => 'blog'],
    ];
    echo '<header class="site-header" role="banner">';
    echo '<div class="container flex flex-align-center flex-gap">';
    echo '<a class="brand" href="' . esc(site_url()) . '">';
    echo '<img src="' . esc(site_url('assets/logo.svg')) . '" alt="' . esc($siteName) . ' logo" width="32" height="32">';
    echo '<span>' . esc($siteName) . '</span>';
    echo '</a>';
    echo '<nav aria-label="Primary" class="nav-primary">';
    echo '<button class="nav-toggle" aria-expanded="false" aria-controls="nav-menu"><span class="sr-only">Toggle navigation</span></button>';
    echo '<ul id="nav-menu" class="nav-menu">';
    foreach ($nav as $link) {
        $isActive = $active === $link['id'] ? ' aria-current="page"' : '';
        echo '<li><a href="' . esc($link['href']) . '"' . $isActive . '>' . esc($link['label']) . '</a></li>';
    }
    echo '</ul>';
    echo '</nav>';
    echo '<a class="btn btn-primary" href="' . esc(site_url('generate.php')) . '">Create free image</a>';
    echo '</div>';
    echo '</header>';
}

function render_footer(): void
{
    $year = date('Y');
    $siteName = site_config('SITE_NAME', 'NebulaCanvas');
    echo '<footer class="site-footer" role="contentinfo">';
    echo '<div class="container grid-footer">';
    echo '<div><strong>' . esc($siteName) . '</strong><p>Mindful AI visuals that vanish for your privacy.</p></div>';
    echo '<div><h3>Company</h3><ul><li><a href="' . esc(site_url('privacy.php')) . '">Privacy</a></li><li><a href="' . esc(site_url('terms.php')) . '">Terms</a></li></ul></div>';
    echo '<div><h3>Resources</h3><ul><li><a href="' . esc(site_url('faq.php')) . '">FAQ</a></li><li><a href="' . esc(site_url('blog.php')) . '">Blog</a></li></ul></div>';
    echo '<div><h3>Stay updated</h3><p>No spam newsletter. Coming soon.</p></div>';
    echo '</div>';
    echo '<div class="container footer-bottom"><p>&copy; ' . esc($year) . ' ' . esc($siteName) . '. Auto-delete in 5 minutes. Free forever.</p></div>';
    echo '</footer>';
}