﻿<?php

require_once __DIR__ . '/../bootstrap.php';

use App\Lib\Env;
use App\Lib\Time;

function site_config(string $key, mixed $default = null): mixed
{
    return Env::get($key, $default);
}

function site_url(string $path = ''): string
{
    $base = rtrim((string)Env::get('SITE_URL'), '/');
    $path = ltrim($path, '/');
    return $path ? $base . '/' . $path : $base . '/';
}

function esc(string $value): string
{
    return htmlspecialchars($value, ENT_QUOTES, 'UTF-8');
}

function render_json_ld(array $payload): string
{
    return '<script type="application/ld+json">' . json_encode($payload, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) . '</script>';
}

function format_countdown(int $remainingMs): string
{
    $seconds = (int) round($remainingMs / 1000);
    $minutes = intdiv($seconds, 60);
    $secs = $seconds % 60;
    return sprintf('%02d:%02d', $minutes, $secs);
}

function http_date(int $ms): string
{
    return Time::formatHttp((int)($ms / 1000));
}