﻿<?php

require_once __DIR__ . '/helpers.php';

function schema_website(): array
{
    return [
        '@context' => 'https://schema.org',
        '@type' => 'WebSite',
        'name' => site_config('SITE_NAME', 'NebulaCanvas'),
        'url' => site_url(),
        'potentialAction' => [
            '@type' => 'SearchAction',
            'target' => site_url('generate.php') . '?prompt={search_term_string}',
            'query-input' => 'required name=search_term_string',
        ],
    ];
}

function schema_organization(): array
{
    return [
        '@context' => 'https://schema.org',
        '@type' => 'Organization',
        'name' => site_config('SITE_NAME', 'NebulaCanvas'),
        'url' => site_url(),
        'logo' => site_url('assets/logo.svg'),
    ];
}

function schema_faq(array $faqs): array
{
    $items = [];
    foreach ($faqs as $faq) {
        $items[] = [
            '@type' => 'Question',
            'name' => $faq['question'],
            'acceptedAnswer' => [
                '@type' => 'Answer',
                'text' => $faq['answer'],
            ],
        ];
    }
    return [
        '@context' => 'https://schema.org',
        '@type' => 'FAQPage',
        'mainEntity' => $items,
    ];
}

function schema_article(array $article): array
{
    return [
        '@context' => 'https://schema.org',
        '@type' => 'Article',
        'headline' => $article['title'],
        'datePublished' => $article['published_at'],
        'dateModified' => $article['updated_at'] ?? $article['published_at'],
        'author' => [
            '@type' => 'Organization',
            'name' => site_config('SITE_NAME', 'NebulaCanvas'),
        ],
        'publisher' => [
            '@type' => 'Organization',
            'name' => site_config('SITE_NAME', 'NebulaCanvas'),
            'logo' => [
                '@type' => 'ImageObject',
                'url' => site_url('assets/logo.svg'),
            ],
        ],
        'image' => site_url('assets/og-default.jpg'),
        'mainEntityOfPage' => site_url('blog-article.php?slug=' . urlencode($article['slug'])),
        'description' => $article['excerpt'],
    ];
}