﻿<?php

require_once __DIR__ . '/../../bootstrap.php';

use App\Lib\CleanupService;
use App\Lib\Env;
use App\Lib\Time;

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    json_response(['error' => 'Method Not Allowed'], 405, ['Allow' => 'GET']);
}

$token = $_GET['token'] ?? '';
$expected = Env::get('CRON_TOKEN');
if (!$expected || !hash_equals((string)$expected, (string)$token)) {
    json_response(['error' => 'Forbidden'], 403);
}

$service = new CleanupService();
$now = Time::nowMs();
$deleted = $service->run($now);

json_response([
    'deleted' => $deleted,
    'checkedAt' => $now,
]);