﻿<?php

require_once __DIR__ . '/../../bootstrap.php';

use App\Lib\ImageJobService;
use App\Lib\ImageProviderFactory;
use App\Lib\Logger;
use App\Lib\RateLimiter;
use App\Lib\Validator;
use InvalidArgumentException;
use RuntimeException;
use Throwable;

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    json_response(['error' => 'Method Not Allowed'], 405, ['Allow' => 'POST']);
}

$ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
$rate = RateLimiter::attempt($ip);
if (!$rate['allowed']) {
    json_response(['error' => 'Too Many Requests'], 429, ['Retry-After' => (string)$rate['retryAfter']]);
}

$raw = file_get_contents('php://input');
$data = json_decode($raw, true);
if (!is_array($data)) {
    json_response(['error' => 'Invalid JSON body'], 400);
}

$schema = Validator::imageGeneration();
try {
    $input = $schema->parse($data);
} catch (InvalidArgumentException $e) {
    json_response(['error' => $e->getMessage()], 422);
}

$promptLower = strtolower($input['prompt']);
$blocked = ['nsfw', 'nude', 'gore'];
foreach ($blocked as $term) {
    if (str_contains($promptLower, $term)) {
        json_response(['error' => 'Prompt violates safety policy.'], 400);
    }
}

try {
    $provider = ImageProviderFactory::make();
    $result = $provider->generate($input);

    if (!$result->binary) {
        throw new RuntimeException('Provider returned empty payload.');
    }

    $service = new ImageJobService();
    $record = $service->persist($input, $result);

    json_response([
        'jobId' => $record['jobId'],
        'imageId' => $record['imageId'],
        'etaSec' => 0,
        'deleteAt' => $record['deleteAt'],
    ]);
} catch (Throwable $e) {
    Logger::exception($e);
    json_response(['error' => 'Image generation failed.'], 500);
}