﻿<?php

require_once __DIR__ . '/../../bootstrap.php';

use App\Lib\Db;
use App\Lib\StorageService;
use App\Lib\Time;

$method = $_SERVER['REQUEST_METHOD'] ?? 'GET';
if (!in_array($method, ['GET', 'HEAD'], true)) {
    json_response(['error' => 'Method Not Allowed'], 405, ['Allow' => 'GET, HEAD']);
}

$id = $_GET['id'] ?? '';
$id = trim((string)$id);
if ($id === '') {
    json_response(['error' => 'id is required'], 400);
}

$pdo = Db::conn();
$stmt = $pdo->prepare('SELECT id, deleteAt, filePath, mime FROM images WHERE id = :id');
$stmt->execute([':id' => $id]);
$row = $stmt->fetch();

if (!$row) {
    json_response(['reason' => 'expired'], 410);
}

$now = Time::nowMs();
if ($now >= (int)$row['deleteAt']) {
    StorageService::delete($row['filePath']);
    $del = $pdo->prepare('DELETE FROM images WHERE id = :id');
    $del->execute([':id' => $id]);
    json_response(['reason' => 'expired'], 410);
}

$file = $row['filePath'];
if (!$file || !file_exists($file)) {
    $del = $pdo->prepare('DELETE FROM images WHERE id = :id');
    $del->execute([':id' => $id]);
    json_response(['reason' => 'expired'], 410);
}

$mime = $row['mime'] ?: 'application/octet-stream';
$length = filesize($file) ?: null;

header('Cache-Control: no-store, max-age=0, private');
header('Pragma: no-cache');
header('Expires: 0');
header('Content-Type: ' . $mime);
header('X-Content-Type-Options: nosniff');
header('Referrer-Policy: strict-origin-when-cross-origin');
header('Content-Security-Policy: default-src \''self\'' data:; img-src \''self\'' data:; style-src \''self\'' \''unsafe-inline\''; script-src \''self\'' \''unsafe-inline\''');

if ($length !== null) {
    header('Content-Length: ' . $length);
}

if ($method === 'HEAD') {
    exit;
}

$handle = fopen($file, 'rb');
if (!$handle) {
    json_response(['reason' => 'expired'], 410);
}
while (!feof($handle)) {
    echo fread($handle, 8192);
}
fclose($handle);
exit;