﻿<?php

require_once __DIR__ . '/../../bootstrap.php';

use App\Lib\Db;
use App\Lib\Time;

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    json_response(['error' => 'Method Not Allowed'], 405, ['Allow' => 'GET']);
}

$jobId = $_GET['jobId'] ?? '';
$jobId = trim((string)$jobId);
if ($jobId === '') {
    json_response(['error' => 'jobId is required'], 400);
}

$pdo = Db::conn();
$stmt = $pdo->prepare('SELECT j.id, j.status, j.progress, j.imageId, j.error, i.deleteAt FROM jobs j LEFT JOIN images i ON i.id = j.imageId WHERE j.id = :id');
$stmt->execute([':id' => $jobId]);
$job = $stmt->fetch();

if (!$job) {
    json_response(['error' => 'Job not found'], 404);
}

$response = [
    'status' => $job['status'],
    'progress' => (int)$job['progress'],
];

if ($job['error']) {
    $response['error'] = $job['error'];
}

if ($job['imageId']) {
    $response['imageId'] = $job['imageId'];
}

if ($job['deleteAt']) {
    $remaining = max(0, (int)$job['deleteAt'] - Time::nowMs());
    $response['remainingMs'] = $remaining;
}

json_response($response);