﻿<?php
require_once __DIR__ . '/../partials/meta.php';
require_once __DIR__ . '/../partials/header.php';
require_once __DIR__ . '/../partials/schema.php';

use App\Lib\ContentRepository;

$repo = new ContentRepository();
$posts = $repo->blogIndex();

render_head([
    'title' => 'Blog',
    'description' => 'Product updates and operational tips for running NebulaCanvas on budget-friendly infrastructure.',
    'page' => 'blog',
]);
render_header('blog');
?>
<main class="container flow">
    <header class="page-header">
        <h1>Insights &amp; updates</h1>
        <p>Fresh notes on performance tuning, privacy, and prompt design.</p>
    </header>
    <div class="blog-list">
        <?php if (empty($posts)): ?>
            <p>No posts yet. Check back soon.</p>
        <?php else: ?>
            <?php foreach ($posts as $post): ?>
                <article class="card blog-card">
                    <h2><a href="<?= esc(site_url('blog-article.php?slug=' . urlencode($post['slug']))); ?>"><?= esc($post['title']); ?></a></h2>
                    <p class="muted">Published <?= esc(date('F j, Y', strtotime($post['published_at']))); ?></p>
                    <p><?= esc($post['excerpt']); ?></p>
                    <a class="btn btn-link" href="<?= esc(site_url('blog-article.php?slug=' . urlencode($post['slug']))); ?>">Read article</a>
                </article>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</main>
<?php render_footer(); render_foot(); ?>