﻿<?php
require_once __DIR__ . '/../partials/meta.php';
require_once __DIR__ . '/../partials/header.php';
require_once __DIR__ . '/../partials/schema.php';

$faqs = [
    [
        'question' => 'Is the site really free?',
        'answer' => 'Yes. The default mock provider generates art locally with PHP so there are no per-image fees.',
    ],
    [
        'question' => 'How do I switch to a real diffusion model?',
        'answer' => 'Set PROVIDER=remote_http in config.php and point REMOTE_HTTP_ENDPOINT to your inference API.',
    ],
    [
        'question' => 'What happens after five minutes?',
        'answer' => 'The API responds with HTTP 410 and the cleanup cron removes the file and metadata immediately.',
    ],
    [
        'question' => 'Do you support analytics?',
        'answer' => 'Drop in a privacy-friendly analytics script (Plausible or Umami) in partials/meta.php if you need stats.',
    ],
    [
        'question' => 'Can I disable the watermark?',
        'answer' => 'Yes. Set WATERMARK_ENABLED=false in config.php or leave the text blank.',
    ],
];

render_head([
    'title' => 'FAQ',
    'description' => 'Answers to common questions about deployment, privacy, and customization of the NebulaCanvas AI image app.',
    'schema' => [schema_faq($faqs)],
    'page' => 'faq',
]);
render_header('faq');
?>
<main class="container flow">
    <header class="page-header">
        <h1>Frequently asked questions</h1>
        <p>Everything you need to know before deploying to shared hosting.</p>
    </header>
    <dl class="faq-list">
        <?php foreach ($faqs as $item): ?>
            <div>
                <dt><?= esc($item['question']); ?></dt>
                <dd><?= esc($item['answer']); ?></dd>
            </div>
        <?php endforeach; ?>
    </dl>
</main>
<?php render_footer(); render_foot(); ?>