﻿<?php
require_once __DIR__ . '/../partials/meta.php';
require_once __DIR__ . '/../partials/header.php';
require_once __DIR__ . '/../partials/schema.php';

$schemas = [schema_website(), schema_organization()];
render_head([
    'title' => site_config('SITE_NAME', 'NebulaCanvas'),
    'description' => 'Generate serene AI visuals instantly. Zero cost. Auto-deletes after five minutes for privacy-first creativity.',
    'schema' => $schemas,
    'page' => 'home',
]);
render_header('home');
?>
<main class="container flow">
    <section class="hero">
        <div class="hero-copy">
            <h1>Lightweight AI art that disappears in five minutes</h1>
            <p>Compose calming imagery, test prompt ideas, and share safely. Every render is free, private, and ephemeral.</p>
            <div class="hero-actions">
                <a class="btn btn-primary" href="<?= esc(site_url('generate.php')); ?>">Start generating</a>
                <a class="btn btn-secondary" href="#how-it-works">How it works</a>
            </div>
            <dl class="hero-stats" aria-label="Highlights">
                <div><dt>0 cost</dt><dd>Mock provider ships free art instantly.</dd></div>
                <div><dt>5 minute TTL</dt><dd>Storage resets automatically for privacy.</dd></div>
                <div><dt>&lt;1s LCP</dt><dd>Tuned for Core Web Vitals on shared hosting.</dd></div>
            </dl>
        </div>
        <div class="hero-visual" aria-hidden="true">
            <div class="preview-frame">
                <img src="<?= esc(site_url('assets/og-default.jpg')); ?>" alt="Preview of generated artwork" loading="lazy">
                <div class="preview-countdown">05:00 remaining</div>
            </div>
        </div>
    </section>

    <section id="how-it-works" class="grid-steps">
        <article>
            <h2>Generate</h2>
            <p>Enter a prompt and optional dimensions. Our default mock provider responds immediately so people can experiment for free.</p>
        </article>
        <article>
            <h2>Share</h2>
            <p>Copy the prompt, download the file, or embed the secure streaming link. We stamp an optional watermark to credit your platform.</p>
        </article>
        <article>
            <h2>Expire</h2>
            <p>A precise five-minute timer triggers deletion of the image file and metadata. No manual cleanup required.</p>
        </article>
    </section>

    <section class="card" id="provider">
        <h2>Swap providers without touching the UI</h2>
        <p>The app ships with a mock provider for demos and a documented RemoteHTTP provider for real inference endpoints. Toggle a single config value to go live.</p>
        <ul class="checklist">
            <li>Config-driven switch between `mock` and `remote_http`.</li>
            <li>Pure PHP HTTP client with timeout and API key support.</li>
            <li>No background workers required on shared hosting.</li>
        </ul>
    </section>

    <section class="testimonials" aria-label="Testimonials">
        <figure>
            <blockquote>"The five-minute expiry made it easy to run community challenges without worrying about cleanup."</blockquote>
            <figcaption>- Maya, Community Designer</figcaption>
        </figure>
        <figure>
            <blockquote>"Fast, quiet, and private. My students love experimenting without account friction."</blockquote>
            <figcaption>- Leo, Art Teacher</figcaption>
        </figure>
    </section>

    <section class="cta card">
        <h2>Ready to delight your visitors?</h2>
        <p>Zip, upload, and launch. No build tooling, no hidden costs.</p>
        <a class="btn btn-primary" href="<?= esc(site_url('generate.php')); ?>">Generate your first image</a>
    </section>
</main>
<?php render_footer(); render_foot(); ?>