﻿<?php

use App\Lib\Db;
use App\Lib\ImageJobService;
use App\Lib\ImageProviderResult;
use PHPUnit\Framework\TestCase;

final class ImageJobServiceTest extends TestCase
{
    public function testComputeDeleteAtAddsFiveMinutes(): void
    {
        $created = 1_700_000_000_000;
        $deleteAt = ImageJobService::computeDeleteAt($created);
        $this->assertSame($created + 300000, $deleteAt);
    }

    public function testPersistStoresImageAndJob(): void
    {
        $service = new ImageJobService();
        $input = [
            'prompt' => 'Test prompt',
            'width' => 512,
            'height' => 512,
        ];
        $binary = base64_decode('iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVR42mP8/5+hHgAHggJ/P0LtOAAAAABJRU5ErkJggg==');
        $result = new ImageProviderResult('image/png', $binary);
        $now = 1_700_000_000_000;
        $record = $service->persist($input, $result, $now);

        $this->assertSame($now + 300000, $record['deleteAt']);
        $pdo = Db::conn();
        $stmt = $pdo->prepare('SELECT * FROM images WHERE id = :id');
        $stmt->execute([':id' => $record['imageId']]);
        $image = $stmt->fetch();
        $this->assertNotFalse($image);
        $this->assertSame('Test prompt', $image['prompt']);
    }
}