﻿<?php

use App\Lib\Db;
use App\Lib\RateLimiter;
use PHPUnit\Framework\TestCase;

final class RateLimiterTest extends TestCase
{
    protected function setUp(): void
    {
        parent::setUp();
        Db::conn()->exec('DELETE FROM rate_limits');
    }

    public function testRateLimiterBlocksAfterLimit(): void
    {
        $ip = '127.0.0.1';
        for ($i = 0; $i < 10; $i++) {
            $res = RateLimiter::attempt($ip);
            $this->assertTrue($res['allowed']);
        }
        $blocked = RateLimiter::attempt($ip);
        $this->assertFalse($blocked['allowed']);
        $this->assertGreaterThanOrEqual(1, $blocked['retryAfter']);
    }
}