﻿<?php

use App\Lib\Validator;
use InvalidArgumentException;
use PHPUnit\Framework\TestCase;

final class ValidatorTest extends TestCase
{
    public function testValidInput(): void
    {
        $schema = Validator::imageGeneration();
        $result = $schema->parse([
            'prompt' => 'Calm ocean',
            'width' => 2000,
            'height' => 128,
            'steps' => 200,
            'guidance' => 50,
        ]);
        $this->assertSame(1024, $result['width']);
        $this->assertSame(256, $result['height']);
        $this->assertSame(150, $result['steps']);
        $this->assertSame(30.0, $result['guidance']);
    }

    public function testPromptRequired(): void
    {
        $schema = Validator::imageGeneration();
        $this->expectException(InvalidArgumentException::class);
        $schema->parse([
            'prompt' => '',
        ]);
    }
}