﻿<?php

error_reporting(E_ALL & ~E_NOTICE);
ini_set('display_errors', getenv('APP_ENV') === 'local' ? '1' : '0');

spl_autoload_register(function (string $class): void {
    $prefix = 'App\\';
    if (strncmp($class, $prefix, strlen($prefix)) !== 0) {
        return;
    }
    $relative = substr($class, strlen($prefix));
    $path = __DIR__ . '/' . str_replace('\\', '/', $relative) . '.php';
    $path = str_replace('/Lib/', '/lib/', $path);
    $path = str_replace('/Providers/', '/providers/', $path);
    if (file_exists($path)) {
        require_once $path;
    }
});

// Shared helper for JSON responses
function json_response(array $data, int $status = 200, array $headers = []): void
{
    http_response_code($status);
    header('Content-Type: application/json; charset=utf-8');
    foreach ($headers as $name => $value) {
        header($name . ': ' . $value);
    }
    echo json_encode($data, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
    exit;
}