﻿---
title: Building a Lightweight AI Image App for Shared Hosting
slug: building-lightweight-ai-image-app
published_at: 2025-10-07T00:00:00+00:00
description: How we tuned NebulaCanvas to run fast on PHP shared hosting while keeping images ephemeral.
excerpt: We walk through the caching, SQLite, and UX decisions that make NebulaCanvas fast, private, and deployable on shared hosting.
---

# The shared hosting reality

Running modern AI experiences on shared hosting means every byte matters. We leaned on PHP 8.1, SQLite, and static assets to deliver a responsive feel without build tooling.

## Highlights

- File-backed queues with SQLite keep the cron job simple.
- Tailwind is precompiled locally, so uploads stay tiny.
- Images auto-delete at five minutes for predictable storage.

## Developer setup tips

Use `php -S localhost:8000 -t public_html` to preview locally. Regenerate CSS with `make css` before shipping.