﻿<?php

namespace App\Lib;

class CleanupService
{
    private $deleter;

    public function __construct(callable $deleter = null)
    {
        $this->deleter = $deleter ?? [StorageService::class, 'delete'];
    }

    public function run(?int $nowMs = null, int $limit = 200): int
    {
        $now = $nowMs ?? Time::nowMs();
        $pdo = Db::conn();
        $stmt = $pdo->prepare('SELECT id, filePath FROM images WHERE deleteAt <= :now LIMIT :limit');
        $stmt->bindValue(':now', $now, \PDO::PARAM_INT);
        $stmt->bindValue(':limit', $limit, \PDO::PARAM_INT);
        $stmt->execute();
        $rows = $stmt->fetchAll();
        $deleted = 0;
        foreach ($rows as $row) {
            ($this->deleter)($row['filePath']);
            $del = $pdo->prepare('DELETE FROM images WHERE id = :id');
            $del->execute([':id' => $row['id']]);
            $deleted++;
        }
        return $deleted;
    }
}