﻿<?php

namespace App\Lib;

class Env
{
    private static array $config;

    private static function ensureLoaded(): void
    {
        if (!isset(self::$config)) {
            $path = dirname(__DIR__, 1) . '/config.php';
            if (!file_exists($path)) {
                throw new \RuntimeException('config.php not found.');
            }
            $config = require $path;
            if (!is_array($config)) {
                throw new \RuntimeException('config.php must return an array.');
            }
            self::$config = $config;
        }
    }

    public static function get(string $key, mixed $default = null): mixed
    {
        self::ensureLoaded();
        return self::$config[$key] ?? $default;
    }

    public static function all(): array
    {
        self::ensureLoaded();
        return self::$config;
    }
}