﻿<?php

require_once __DIR__ . '/helpers.php';

function render_head(array $meta = []): void
{
    $siteName = site_config('SITE_NAME', 'NebulaCanvas');
    $title = $meta['title'] ?? $siteName;
    $fullTitle = $title === $siteName ? $title : $title . ' - ' . $siteName;
    $description = $meta['description'] ?? 'Generate calming AI artwork instantly. Free, privacy-first, and every image auto-expires in five minutes.';
    $requestPath = $_SERVER['REQUEST_URI'] ?? '/';
    $canonical = $meta['canonical'] ?? site_url(ltrim($requestPath, '/'));
    $ogImage = $meta['image'] ?? site_url('assets/og-default.jpg');
    $extraScripts = $meta['scripts'] ?? [];

    echo '<!DOCTYPE html><html lang="en" data-theme="dark">';
    echo '<head>';
    echo '<meta charset="utf-8">';
    echo '<meta http-equiv="X-UA-Compatible" content="IE=edge">';
    echo '<meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover">';
    echo '<title>' . esc($fullTitle) . '</title>';
    echo '<meta name="description" content="' . esc($description) . '">';
    echo '<link rel="canonical" href="' . esc($canonical) . '">';
    echo '<meta property="og:type" content="website">';
    echo '<meta property="og:site_name" content="' . esc($siteName) . '">';
    echo '<meta property="og:title" content="' . esc($fullTitle) . '">';
    echo '<meta property="og:description" content="' . esc($description) . '">';
    echo '<meta property="og:url" content="' . esc($canonical) . '">';
    echo '<meta property="og:image" content="' . esc($ogImage) . '">';
    echo '<meta name="twitter:card" content="summary_large_image">';
    echo '<meta name="twitter:title" content="' . esc($fullTitle) . '">';
    echo '<meta name="twitter:description" content="' . esc($description) . '">';
    echo '<meta name="twitter:image" content="' . esc($ogImage) . '">';
    echo '<meta name="theme-color" content="#0B1220">';
    echo '<meta name="color-scheme" content="dark light">';
    echo '<link rel="preload" href="' . esc(site_url('assets/styles.css')) . '" as="style">';
    echo '<link rel="stylesheet" href="' . esc(site_url('assets/theme.css')) . '">';
    echo '<link rel="stylesheet" href="' . esc(site_url('assets/styles.css')) . '">';
    echo '<link rel="icon" href="' . esc(site_url('assets/logo.svg')) . '" type="image/svg+xml">';
    echo '<link rel="apple-touch-icon" href="' . esc(site_url('assets/og-default.jpg')) . '">';

    if (!empty($meta['schema'])) {
        foreach ($meta['schema'] as $schema) {
            echo render_json_ld($schema);
        }
    }

    echo '<script defer src="' . esc(site_url('assets/app.js')) . '"></script>';
    foreach ($extraScripts as $script) {
        echo $script;
    }
    echo '</head>';
    echo '<body class="bg-base text-primary" data-page="' . esc($meta['page'] ?? '') . '">';
}

function render_foot(): void
{
    echo '</body></html>';
}