﻿<?php
require_once __DIR__ . '/../partials/meta.php';
require_once __DIR__ . '/../partials/header.php';
require_once __DIR__ . '/../partials/schema.php';

use App\Lib\ContentRepository;

$slug = trim($_GET['slug'] ?? '');
$repo = new ContentRepository();
$post = $slug ? $repo->findBlog($slug) : null;

if (!$post) {
    http_response_code(404);
    render_head([
        'title' => 'Article not found',
        'description' => 'The requested article could not be found.',
        'page' => 'blog',
    ]);
    render_header('blog');
    ?>
    <main class="container flow">
        <h1>Article not found</h1>
        <p>The article may have been removed or the link is outdated.</p>
        <a class="btn btn-primary" href="<?= esc(site_url('blog.php')); ?>">Back to blog</a>
    </main>
    <?php
    render_footer();
    render_foot();
    exit;
}

$schema = schema_article($post);
render_head([
    'title' => $post['title'],
    'description' => $post['excerpt'],
    'schema' => [$schema],
    'page' => 'blog',
]);
render_header('blog');
?>
<main class="container flow">
    <article class="blog-article">
        <header>
            <h1><?= esc($post['title']); ?></h1>
            <p class="muted">Published <?= esc(date('F j, Y', strtotime($post['published_at']))); ?></p>
        </header>
        <div class="blog-content">
            <?= $post['html']; ?>
        </div>
        <footer>
            <a class="btn btn-link" href="<?= esc(site_url('blog.php')); ?>">Back to all articles</a>
        </footer>
    </article>
</main>
<?php render_footer(); render_foot(); ?>