﻿<?php
require_once __DIR__ . '/../partials/meta.php';
require_once __DIR__ . '/../partials/header.php';
require_once __DIR__ . '/../partials/schema.php';

render_head([
    'title' => 'Features',
    'description' => 'Explore the privacy, performance, and accessibility features that make NebulaCanvas production-ready on shared hosting.',
    'page' => 'features',
]);
render_header('features');
?>
<main class="container flow">
    <header class="page-header">
        <h1>Purpose-built for shared hosting</h1>
        <p>Every detail-from rate limiting to cleanup-runs on PHP 8.1 with zero daemons or background workers.</p>
    </header>

    <section class="grid-features">
        <article>
            <h2>Instant mock provider</h2>
            <p>Respond with tasteful placeholder art for demos or education. Flip a config switch to connect a real diffusion endpoint.</p>
        </article>
        <article>
            <h2>Exact five-minute expiry</h2>
            <p>deleteAt timestamps live in SQLite. Requests past the TTL receive an HTTP 410 and the cleanup cron sweeps stragglers.</p>
        </article>
        <article>
            <h2>Accessible UI</h2>
            <p>WCAG-compliant colors, focus outlines, and aria-live updates keep everything usable with screen readers and keyboards.</p>
        </article>
        <article>
            <h2>SEO-first</h2>
            <p>Server-rendered pages, structured data, and an auto-built sitemap help search engines understand your experience.</p>
        </article>
        <article>
            <h2>Rate limited</h2>
            <p>A SQLite sliding window caps requests per IP at 10/min by default to curb abuse without external services.</p>
        </article>
        <article>
            <h2>Security hardened</h2>
            <p>Storage directories are sealed by .htaccess, image streaming disables caching, and CSP headers protect against injection.</p>
        </article>
    </section>

    <section class="card">
        <h2>Under the hood</h2>
        <ul class="feature-list">
            <li><code>/api/generate.php</code> validates prompts, enforces rate limits, and stores metadata.</li>
            <li><code>/api/image.php</code> streams files with <abbr title="Hypertext Transfer Protocol">HTTP</abbr> 410 once expired.</li>
            <li><code>/api/cleanup.php</code> provides a cron-safe endpoint guarded by a signed token.</li>
            <li>Configurable watermark ensures downstream sharing still credits your site.</li>
        </ul>
    </section>

    <section class="cta card">
        <h2>Deploy in minutes</h2>
        <p>Zip the repository, upload via cPanel, extract into <code>public_html</code>, and add a cron job. Nothing else to install.</p>
        <a class="btn btn-primary" href="<?= esc(site_url('generate.php')); ?>">See the generator</a>
    </section>
</main>
<?php render_footer(); render_foot(); ?>