﻿<?php
require_once __DIR__ . '/../partials/meta.php';
require_once __DIR__ . '/../partials/header.php';

render_head([
    'title' => 'Generate',
    'description' => 'Create AI images with a five-minute lifespan. Accessible, calming UX with live countdowns.',
    'page' => 'generate',
]);
render_header('generate');
?>
<main class="container flow">
    <header class="page-header">
        <h1>Create your image</h1>
        <p>Prompts stay private. Every image vanishes five minutes after creation.</p>
    </header>

    <section class="generate-layout">
        <form id="generate-form" class="card form" novalidate>
            <label for="prompt">Prompt</label>
            <textarea id="prompt" name="prompt" maxlength="500" required placeholder="E.g. A tranquil nebula over calm water in pastel hues"></textarea>
            <div class="hint" id="prompt-hint">Max 500 characters. Safety filters block explicit terms.</div>

            <details>
                <summary>Advanced options</summary>
                <div class="grid-options">
                    <label>Width
                        <input type="number" name="width" min="256" max="1024" step="64" value="768">
                    </label>
                    <label>Height
                        <input type="number" name="height" min="256" max="1024" step="64" value="768">
                    </label>
                    <label>Steps
                        <input type="number" name="steps" min="5" max="150" value="30">
                    </label>
                    <label>Guidance
                        <input type="number" name="guidance" min="1" max="30" step="0.5" value="7.5">
                    </label>
                    <label>Seed
                        <input type="number" name="seed" placeholder="Random">
                    </label>
                </div>
            </details>

            <button class="btn btn-primary" type="submit">Generate image</button>
            <div class="form-foot" aria-live="polite"></div>
        </form>

        <aside class="card" aria-label="Example prompts">
            <h2>Try these prompts</h2>
            <ul class="example-prompts">
                <li><button type="button" data-prompt="Soft watercolor of a moonlit forest clearing" class="prompt-chip">Soft watercolor of a moonlit forest clearing</button></li>
                <li><button type="button" data-prompt="Serene mountains reflected on still water at sunrise" class="prompt-chip">Serene mountains reflected on still water at sunrise</button></li>
                <li><button type="button" data-prompt="Futuristic zen garden inside a glass observatory" class="prompt-chip">Futuristic zen garden inside a glass observatory</button></li>
            </ul>
            <p class="muted">Need a baseline? Tap to populate the prompt field instantly.</p>
        </aside>
    </section>

    <section id="result" class="card result" hidden>
        <header>
            <h2>Result</h2>
            <p class="muted">Expires five minutes after generation. Timer resets only with a fresh prompt.</p>
        </header>
        <div class="result-art">
            <figure>
                <div class="skeleton" aria-hidden="true"></div>
                <img id="result-image" alt="Generated artwork" hidden>
                <div class="countdown" role="status" aria-live="polite">
                    <svg viewBox="0 0 36 36"><path class="ring" d="M18 2a16 16 0 1 1 0 32 16 16 0 0 1 0-32"/><path id="ring-progress" class="ring-progress" d="M18 2a16 16 0 1 1 0 32 16 16 0 0 1 0-32"/></svg>
                    <span id="countdown-text">05:00</span>
                </div>
            </figure>
        </div>
        <dl class="result-meta">
            <div><dt>Prompt</dt><dd><code id="result-prompt"></code></dd></div>
            <div><dt>Dimensions</dt><dd id="result-dimensions"></dd></div>
            <div><dt>Status</dt><dd id="result-status">Queued...</dd></div>
        </dl>
        <div class="result-actions">
            <a id="download-link" class="btn btn-primary" href="#" download>Download</a>
            <button type="button" id="copy-link" class="btn btn-secondary">Copy link</button>
            <button type="button" id="regenerate" class="btn btn-link">Re-generate</button>
        </div>
        <p class="muted" id="expiry-notice" hidden>Image expired. Please generate again.</p>
    </section>
</main>
<?php render_footer(); render_foot(); ?>