﻿<?php
require_once __DIR__ . '/../partials/meta.php';
require_once __DIR__ . '/../partials/header.php';

render_head([
    'title' => 'Privacy Policy',
    'description' => 'Learn how NebulaCanvas handles prompts, generated images, and analytics.',
    'page' => 'privacy',
]);
render_header('privacy');
?>
<main class="container flow prose">
    <h1>Privacy Policy</h1>
    <p>Last updated: <?= esc(date('F j, Y')); ?></p>
    <p>NebulaCanvas is designed for privacy-first exploration. We do not require accounts and we avoid storing personal information.</p>
    <h2>Prompts &amp; images</h2>
    <ul>
        <li>Prompts are persisted in SQLite solely to support the five-minute expiration window.</li>
        <li>Generated images are saved under <code>storage/images</code> with a <strong>deleteAt</strong> timestamp.</li>
        <li>Files and metadata are deleted exactly five minutes after creation via on-demand checks and a cron sweep.</li>
    </ul>
    <h2>Logs</h2>
    <p>We keep minimal server logs for debugging (timestamp, IP, error message). These logs never include prompts or images.</p>
    <h2>Analytics</h2>
    <p>By default, no analytics scripts run. If you enable a privacy-friendly tool such as Plausible, update this page accordingly.</p>
    <h2>Contact</h2>
    <p>Questions? Reach the operator listed in <code>/docs/README.md</code>.</p>
</main>
<?php render_footer(); render_foot(); ?>