﻿<?php
require_once __DIR__ . '/../bootstrap.php';

use App\Lib\ContentRepository;
use App\Lib\Env;

header('Content-Type: application/xml; charset=utf-8');
$base = rtrim(Env::get('SITE_URL'), '/');
$urls = [
    '/index.php',
    '/features.php',
    '/generate.php',
    '/faq.php',
    '/blog.php',
    '/privacy.php',
    '/terms.php',
];

$repo = new ContentRepository();
$posts = $repo->blogIndex();

echo '<?xml version="1.0" encoding="UTF-8"?>';
echo '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';
foreach ($urls as $path) {
    echo '<url><loc>' . htmlspecialchars($base . $path, ENT_QUOTES, 'UTF-8') . '</loc></url>';
}
foreach ($posts as $post) {
    $loc = $base . '/blog-article.php?slug=' . urlencode($post['slug']);
    echo '<url><loc>' . htmlspecialchars($loc, ENT_QUOTES, 'UTF-8') . '</loc>'; 
    echo '<lastmod>' . htmlspecialchars(date('c', strtotime($post['updated_at'])), ENT_QUOTES, 'UTF-8') . '</lastmod></url>';
}
echo '</urlset>';