﻿<?php
$base = rtrim(getenv('BASE_URL') ?: 'http://localhost:8000', '/');
$wait = (int)(getenv('WAIT_SECONDS') ?: 305);
$prompt = 'E2E verification ' . uniqid();

function curl_json(string $method, string $url, array $body = null): array
{
    $ch = curl_init($url);
    $options = [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CUSTOMREQUEST => $method,
        CURLOPT_HTTPHEADER => ['Accept: application/json'],
    ];
    if ($body !== null) {
        $payload = json_encode($body);
        $options[CURLOPT_POSTFIELDS] = $payload;
        $options[CURLOPT_HTTPHEADER][] = 'Content-Type: application/json';
    }
    curl_setopt_array($ch, $options);
    $response = curl_exec($ch);
    if ($response === false) {
        throw new RuntimeException('Curl error: ' . curl_error($ch));
    }
    $status = curl_getinfo($ch, CURLINFO_RESPONSE_CODE);
    curl_close($ch);
    return [$status, $response];
}

[$status, $body] = curl_json('POST', $base . '/api/generate.php', [
    'prompt' => $prompt,
    'width' => 512,
    'height' => 512,
]);
if ($status !== 200) {
    fwrite(STDERR, "Generate failed: $body\n");
    exit(1);
}
$data = json_decode($body, true);
if (!$data) {
    fwrite(STDERR, "Invalid response: $body\n");
    exit(1);
}
$jobId = $data['jobId'];
$imageId = $data['imageId'];
$deleteAt = $data['deleteAt'];

echo "Generated job $jobId image $imageId (deleteAt: $deleteAt)\n";

$done = false;
$attempts = 0;
while (!$done && $attempts < 20) {
    [$status, $progressBody] = curl_json('GET', $base . '/api/progress.php?jobId=' . urlencode($jobId));
    if ($status !== 200) {
        fwrite(STDERR, "Progress failed: $progressBody\n");
        exit(1);
    }
    $progress = json_decode($progressBody, true);
    echo "Status: {$progress['status']}\n";
    if (($progress['status'] ?? '') === 'done') {
        $done = true;
        break;
    }
    sleep(1);
    $attempts++;
}
if (!$done) {
    fwrite(STDERR, "Job did not complete in time\n");
    exit(1);
}

[$status, $imageBody] = curl_json('GET', $base . '/api/image.php?id=' . urlencode($imageId));
if ($status !== 200) {
    fwrite(STDERR, "Image download failed: HTTP $status\n");
    exit(1);
}
$savePath = __DIR__ . '/tmp/' . $imageId . '.png';
if (!is_dir(dirname($savePath))) {
    mkdir(dirname($savePath), 0777, true);
}
file_put_contents($savePath, $imageBody);
echo "Saved image to $savePath\n";

echo "Waiting $wait seconds for expiry...\n";
sleep($wait);

[$status, $expiredBody] = curl_json('GET', $base . '/api/image.php?id=' . urlencode($imageId));
if ($status !== 410) {
    fwrite(STDERR, "Expected 410 after expiry, got $status\n");
    exit(1);
}

echo "Expiry confirmed.\n";