﻿<?php

use App\Lib\CleanupService;
use App\Lib\Db;
use PHPUnit\Framework\TestCase;

final class CleanupServiceTest extends TestCase
{
    protected function setUp(): void
    {
        parent::setUp();
        $pdo = Db::conn();
        $pdo->exec('DELETE FROM jobs');
        $pdo->exec('DELETE FROM images');
    }

    public function testCleanupDeletesExpiredImages(): void
    {
        $pdo = Db::conn();
        $path = dirname(__DIR__, 2) . '/tests/tmp/images/demo.png';
        file_put_contents($path, 'demo');
        $pdo->prepare('INSERT INTO images (id, createdAt, deleteAt, prompt, width, height, filePath, mime, status) VALUES (:id, :createdAt, :deleteAt, :prompt, :width, :height, :filePath, :mime, :status)')
            ->execute([
                ':id' => 'test-image',
                ':createdAt' => 100,
                ':deleteAt' => 120,
                ':prompt' => 'demo',
                ':width' => 512,
                ':height' => 512,
                ':filePath' => $path,
                ':mime' => 'image/png',
                ':status' => 'done',
            ]);

        $deletedPaths = [];
        $service = new CleanupService(function (string $file) use (&$deletedPaths) {
            $deletedPaths[] = $file;
            if (file_exists($file)) {
                unlink($file);
            }
        });
        $count = $service->run(200);
        $this->assertSame(1, $count);
        $this->assertSame([$path], $deletedPaths);
        $stmt = $pdo->query('SELECT COUNT(*) as cnt FROM images');
        $this->assertSame('0', $stmt->fetch()['cnt']);
    }
}